﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Graphics;
using CashierCrisis.Managers;
using CashierCrisis.Core;

namespace CashierCrisis.UserInterface
{
    public class PressStartUI: UI
    {
        UIText startGame;

        public PressStartUI(Game game)
            : base(game)
        {
            FontManager fontManager = CashierGame.Instance.Services.GetService(typeof(FontManager)) as FontManager;
            SpriteFont font = fontManager.GetFont("Default");
            
            startGame = new UIText("Press Start to Begin");
            startGame.Font = font;
            startGame.Position = Parameters.GetParam<Vector2>("MenuSlot1");
           
            AddWidget(startGame);
        }



        public override void Update(Microsoft.Xna.Framework.GameTime gameTime)
        {
            for (int i = 0; i < 4; i++)
            {
                PlayerIndex currentPlayer = (PlayerIndex)i;
                GamePadState gamePadState = GamePad.GetState(currentPlayer);

                if (gamePadState.IsButtonDown(Buttons.Start))
                {
                    InputManager input = CashierGame.Instance.Services.GetService(typeof(InputManager)) as InputManager;
                    input.Player = currentPlayer;
                    Visible = false;
                    UIManager.SwapUserInterface("MainMenu");
                    break;
                }
                else
                {
                    InputManager input = CashierGame.Instance.Services.GetService(typeof(InputManager)) as InputManager;

                    if(input.ConfirmButton())
                    {
                        Visible = false;
                        UIManager.SwapUserInterface("MainMenu");
                        break;
                    }
                }

               

            }
            base.Update(gameTime);
        }
      
    }
}
